dojo.require("dojox.widget.AnalogGauge");
dojo.require("dojox.widget.gauge.AnalogArrowIndicator");

var Graficos = function() {
  this.json_data = null;
  this.desenhados = false;
  this.atualizar = true;

  this.mede_temperatura = false;
  this.mede_corrente_carregador = false;

  this.grafico_tensao_entrada = null;
  this.grafico_tensao_saida = null;
  this.grafico_carga = null;
  this.grafico_tensao_bateria = null;
  this.grafico_temperatura = null;

  this.ranges_tensao_entrada = null;
  this.ranges_tensao_saida = null;
  this.ranges_tensao_bateria = null;
  this.ranges_carga = null;
  this.ranges_temperatura = null;
  this.ranges_corrente_carregador = null;

  this.ranges_tensao_120 = [{ low:80,  high:90,  hover:'80 - 90'   },
                            { low:90,  high:100, hover:'90 - 100'  },
                            { low:100, high:110, hover:'100 - 110' },
                            { low:110, high:120, hover:'110 - 120' },
                            { low:120, high:130, hover:'120 - 130' },
                            { low:130, high:140, hover:'130 - 140' },
                            { low:140, high:150, hover:'140 - 150' },
                            { low:150, high:160, hover:'150 - 160' } ];

  this.ranges_tensao_220 = [{ low:150, high:160, hover:'150 - 160' },
                            { low:160, high:170, hover:'160 - 170' },
                            { low:170, high:180, hover:'170 - 180' },
                            { low:180, high:190, hover:'180 - 190' },
                            { low:190, high:200, hover:'190 - 200' },
                            { low:200, high:210, hover:'200 - 210' },
                            { low:210, high:220, hover:'210 - 220' },
                            { low:220, high:230, hover:'220 - 230' },
                            { low:230, high:240, hover:'230 - 240' },
                            { low:240, high:250, hover:'240 - 250' },
                            { low:250, high:260, hover:'250 - 260' },
                            { low:260, high:270, hover:'260 - 270' },
                            { low:270, high:280, hover:'270 - 280' } ];

  this.ranges_0_100 = [ { low:0,  high:10,  hover:'0 - 10'   },
                        { low:10, high:20,  hover:'10 - 20'  },
                        { low:20, high:30,  hover:'20 - 30'  },
                        { low:30, high:40,  hover:'30 - 40'  },
                        { low:40, high:50,  hover:'40 - 50'  },
                        { low:50, high:60,  hover:'50 - 60'  },
                        { low:60, high:70,  hover:'60 - 70'  },
                        { low:70, high:80,  hover:'70 - 80'  },
                        { low:80, high:90,  hover:'80 - 90'  },
                        { low:90, high:100, hover:'90 - 100' } ];

  this.ranges_0_120 = [ { low:0,   high:10,  hover:'0 - 10'    },
                        { low:10,  high:20,  hover:'10 - 20'   },
                        { low:20,  high:30,  hover:'20 - 30'   },
                        { low:30,  high:40,  hover:'30 - 40'   },
                        { low:40,  high:50,  hover:'40 - 50'   },
                        { low:50,  high:60,  hover:'50 - 60'   },
                        { low:60,  high:70,  hover:'60 - 70'   },
                        { low:70,  high:80,  hover:'70 - 80'   },
                        { low:80,  high:90,  hover:'80 - 90'   },
                        { low:90,  high:100, hover:'90 - 100'  },
                        { low:100, high:110, hover:'100 - 110' },
                        { low:110, high:120, hover:'110 - 120' } ];
}
Graficos.prototype.init = function() {
  this.get_and_plot();
}
Graficos.prototype.get_and_plot = function() {
  var me = this;
  me.json_data = null;
  $.ajax( { beforeSend: function(request) {
              request.setRequestHeader('Pragma', 'no-cache');
              request.setRequestHeader('Cache-Control', 'no-cache, must-revalidate');
              request.setRequestHeader('If-Modified-Since', '0');
            },
            dataType: "json",
            error: function(XMLHttpRequest, textStatus, errorThrown) {
              me.atualizar = false;
              if ($('#erro'))
                $('#erro').html('Falha ao acessar o serviço.<br />Os gráficos não serão mais atualizados.');
            },
            success: function(json, textStatus) {
              if (textStatus == 'success') {
                if (json.status == 'ok') {
                  me.json_data = json.evento;
                  me.plot();
                } else {
                  me.atualizar = false;
                  location.reload();
                }
              }
            },
            type: "GET",
            url: "/dados_graficos_gauge"
          });
}
Graficos.prototype.plot = function() {
  var me = this;

  me.mede_temperatura = (this.json_data.mede_temperatura == 'sim');
  me.mede_corrente_carregador = (this.json_data.mede_corrente_carregador == 'sim');;

  if (me.desenhados == false) {
    if (parseFloat(me.json_data.tensao_entrada_nominal) == 120)
      me.ranges_tensao_entrada = me.ranges_tensao_120;
    else
      me.ranges_tensao_entrada = me.ranges_tensao_220;

    me.grafico_tensao_entrada = dojo.byId("grafico_tensao_entrada");
    me.grafico_tensao_entrada = new dojox.widget.AnalogGauge({
      background: {color: 'white'},
      cx: 170,
      cy: 145,
      height: 150,
      hideValues: true,
      id: "grafico_tensao_entrada",
      indicators: [ new dojox.widget.gauge.AnalogArrowIndicator({
                      color: '#E00000',
                      easing: dojo.fx.easing.bounceOut,
                      hover: 'Valor: 0',
                      noChange: true,
                      title: 'Valor',
                      value: 0,
                      width: 3
                    }) ],
      majorTicks: { length: 10, interval: 10, offset: 105 },
      radius: 110,
      ranges: me.ranges_tensao_entrada,
      useRangeStyles: 10,
      width: 350
    }, me.grafico_tensao_entrada);
    me.grafico_tensao_entrada.startup();
  }

  me.grafico_tensao_entrada.indicators[0].noChange = false;
  me.grafico_tensao_entrada.indicators[0].update(parseFloat(me.json_data.tensao_entrada));
  me.grafico_tensao_entrada.indicators[0].noChange = true;
  $('#legenda_tensao_entrada').html('Tensão de entrada: ' + (me.json_data.tensao_entrada + '').replace('.', ',') + ' V');

  if (me.desenhados == false) {
    if (parseFloat(me.json_data.tensao_saida_nominal) == 120)
      me.ranges_tensao_saida = me.ranges_tensao_120;
    else
      me.ranges_tensao_saida = me.ranges_tensao_220;

    me.grafico_tensao_saida = dojo.byId("grafico_tensao_saida");
    me.grafico_tensao_saida = new dojox.widget.AnalogGauge({
      background: {color: 'white'},
      cx: 170,
      cy: 145,
      height: 150,
      hideValues: true,
      id: "grafico_tensao_saida",
      indicators: [ new dojox.widget.gauge.AnalogArrowIndicator({
                      color: '#E00000',
                      easing: dojo.fx.easing.bounceOut,
                      hover: 'Valor: 0',
                      noChange: true,
                      title: 'Valor',
                      value: 0,
                      width: 3
                    }) ],
      majorTicks: { length: 10, interval: 10, offset: 105 },
      radius: 110,
      ranges: me.ranges_tensao_saida,
      useRangeStyles: 10,
      width: 350
    }, me.grafico_tensao_saida);
    me.grafico_tensao_saida.startup();
  }

  me.grafico_tensao_saida.indicators[0].noChange = false;
  me.grafico_tensao_saida.indicators[0].update(parseFloat(me.json_data.tensao_saida));
  me.grafico_tensao_saida.indicators[0].noChange = true;
  $('#legenda_tensao_saida').html('Tensão de saída: ' + (me.json_data.tensao_saida + '').replace('.', ',') + ' V');

  if (me.desenhados == false) {
    me.ranges_tensao_bateria = new Array();

    var range_low = me.json_data.quantidade_baterias * 10;
    var range_high = me.json_data.quantidade_baterias * 14;
    for (var i = range_low; i <= range_high; i++) {
      var low_value = i;
      var high_value = i + 1;
      var hover_value = i + ' - ' + i + 1;
      var obj = { low:low_value, high:high_value, hover:hover_value };
      me.ranges_tensao_bateria.push(obj);
    }

    me.grafico_tensao_bateria = dojo.byId("grafico_tensao_bateria");
    me.grafico_tensao_bateria = new dojox.widget.AnalogGauge({
      background: {color: 'white'},
      cx: 170,
      cy: 145,
      height: 150,
      hideValues: true,
      id: "grafico_tensao_bateria",
      indicators: [ new dojox.widget.gauge.AnalogArrowIndicator({
                      color: '#E00000',
                      easing: dojo.fx.easing.bounceOut,
                      hover: 'Valor: 0',
                      noChange: true,
                      title: 'Valor',
                      value: 0,
                      width: 3
                    }) ],
      majorTicks: { length: 10, interval: 1, offset: 105 },
      radius: 110,
      ranges: me.ranges_tensao_bateria,
      useRangeStyles: 10,
      width: 350
    }, me.grafico_tensao_bateria);
    me.grafico_tensao_bateria.startup();
  }

  me.grafico_tensao_bateria.indicators[0].noChange = false;
  me.grafico_tensao_bateria.indicators[0].update(parseFloat(me.json_data.tensao_bateria));
  me.grafico_tensao_bateria.indicators[0].noChange = true;
  $('#legenda_tensao_bateria').html('Tensão da bateria: ' + (me.json_data.tensao_bateria + '').replace('.', ',') + ' V');

  if (me.desenhados == false) {
    me.ranges_carga = me.ranges_0_120;

    me.grafico_carga = dojo.byId("grafico_carga");
    me.grafico_carga = new dojox.widget.AnalogGauge({
      background: {color: 'white'},
      cx: 170,
      cy: 145,
      height: 150,
      hideValues: true,
      id: "grafico_carga",
      indicators: [ new dojox.widget.gauge.AnalogArrowIndicator({
                      color: '#E00000',
                      easing: dojo.fx.easing.bounceOut,
                      hover: 'Valor: 0',
                      noChange: true,
                      title: 'Valor',
                      value: 0,
                      width: 3
                    }) ],
      majorTicks: { length: 10, interval: 10, offset: 105 },
      radius: 110,
      ranges: me.ranges_carga,
      useRangeStyles: 10,
      width: 350
    }, me.grafico_carga);
    me.grafico_carga.startup();
  }

  me.grafico_carga.indicators[0].noChange = false;
  me.grafico_carga.indicators[0].update(parseFloat(me.json_data.carga));
  me.grafico_carga.indicators[0].noChange = true;
  $('#legenda_carga').html('Carga: ' + (me.json_data.carga + '').replace('.', ',') + ' %');

  if (me.mede_temperatura) {
    if (me.desenhados == false) {
      me.ranges_temperatura = me.ranges_0_100;
  
      me.grafico_temperatura = dojo.byId("grafico_temperatura");
      me.grafico_temperatura = new dojox.widget.AnalogGauge({
        background: {color: 'white'},
        cx: 170,
        cy: 145,
        height: 150,
        hideValues: true,
        id: "grafico_temperatura",
        indicators: [ new dojox.widget.gauge.AnalogArrowIndicator({
                        color: '#E00000',
                        easing: dojo.fx.easing.bounceOut,
                        hover: 'Valor: 0',
                        noChange: true,
                        title: 'Valor',
                        value: 0,
                        width: 3
                      }) ],
        majorTicks: { length: 10, interval: 10, offset: 105 },
        radius: 110,
        ranges: me.ranges_temperatura,
        useRangeStyles: 10,
        width: 350
      }, me.grafico_temperatura);
      me.grafico_temperatura.startup();
    }

    me.grafico_temperatura.indicators[0].noChange = false;
    me.grafico_temperatura.indicators[0].update(parseFloat(me.json_data.temperatura));
    me.grafico_temperatura.indicators[0].noChange = true;
    $('#legenda_temperatura').html('Temperatura: ' + (me.json_data.temperatura + '').replace('.', ',') + ' &#176;C');
  } else {
    $('#temperatura_header').remove();
    $('#temperatura_body').remove();
  }

  if (me.mede_corrente_carregador) {
    if (me.desenhados == false) {
      me.ranges_corrente_carregador = new Array();
  
      var range_low = 0;
      var range_high = me.json_data.corrente_nominal_carregador * 2;
      if (range_high == 0)
        range_high = 1500;
      var i = range_low;
      while (i <= range_high) {
        var low_value = i;
        var high_value = i + 200;
        var hover_value = i + ' - ' + i + 200;
        var obj = { low:low_value, high:high_value, hover:hover_value };
        me.ranges_corrente_carregador.push(obj);
        i = i + 200;
      }
  
      me.grafico_corrente_carregador = dojo.byId("grafico_corrente_carregador");
      me.grafico_corrente_carregador = new dojox.widget.AnalogGauge({
        background: {color: 'white'},
        cx: 170,
        cy: 145,
        height: 150,
        hideValues: true,
        id: "grafico_corrente_carregador",
        indicators: [ new dojox.widget.gauge.AnalogArrowIndicator({
                        color: '#E00000',
                        easing: dojo.fx.easing.bounceOut,
                        hover: 'Valor: 0',
                        noChange: true,
                        title: 'Valor',
                        value: 0,
                        width: 3
                      }) ],
        majorTicks: { length: 10, interval: 200, offset: 105 },
        radius: 110,
        ranges: me.ranges_corrente_carregador,
        useRangeStyles: 10,
        width: 350
      }, me.grafico_corrente_carregador);
      me.grafico_corrente_carregador.startup();
    }
  
    me.grafico_corrente_carregador.indicators[0].noChange = false;
    me.grafico_corrente_carregador.indicators[0].update(parseFloat(me.json_data.corrente_carregador));
    me.grafico_corrente_carregador.indicators[0].noChange = true;
    $('#legenda_corrente_carregador').html('Corrente do carregador: ' + (me.json_data.corrente_carregador + '').replace('.', ',') + ' mA');
  } else {
    $('#corrente_carregador_header').remove();
    $('#corrente_carregador_body').remove();
  }

  if (!me.mede_temperatura && !me.mede_corrente_carregador) {
    $('#temp_cc_table').remove();
  }

  me.desenhados = true;
}
Graficos.prototype.reget_and_replot = function() {
  if (this.atualizar && this.desenhados)
    this.get_and_plot();
}

$(function() {
  if ($('#graficos').length > 0) {
    var graficos = new Graficos();
    graficos.init();

    $(document).everyTime(3000, function(i) {
      graficos.reget_and_replot();
    });
  }
});

