var Graficos = function() {
  this.json_data = null;
  this.desenhados = false;
  this.atualizar = true;

  this.options =  { legend: { show: false } };

  this.mede_temperatura = false;
  this.mede_corrente_carregador = false;

  this.grafico_tensao_entrada = null;
  this.grafico_tensao_saida = null;
  this.grafico_carga = null;
  this.grafico_tensao_bateria = null;
  this.grafico_temperatura = null;
  this.grafico_corrente_carregador = null;
}
Graficos.prototype.init = function() {
  this.get_and_plot();
}
Graficos.prototype.get_and_plot = function() {
  var me = this;
  me.json_data = null;
  $.ajax( { beforeSend: function(request) {
              request.setRequestHeader('Pragma', 'no-cache');
              request.setRequestHeader('Cache-Control', 'no-cache, must-revalidate');
              request.setRequestHeader('If-Modified-Since', '0');
            },
            dataType: "json",
            error: function(XMLHttpRequest, textStatus, errorThrown) {
              me.atualizar = false;
              if ($('#erro'))
                $('#erro').html('Falha ao acessar o serviço.<br />Os gráficos não serão mais atualizados.');
            },
            success: function(json, textStatus) {
              if (textStatus == 'success') {
                if (json.status == 'ok') {
                  me.json_data = json.eventos;
                  me.plot();
                } else {
                  me.atualizar = false;
                  location.reload();
                }
              }
            },
            type: "GET",
            url: "/dados_graficos"
          });
}
Graficos.prototype.plot = function() {
  var tensao_entrada_data = new Array();
  var tensao_saida_data = new Array();
  var tensao_bateria_data = new Array();
  var carga_data = new Array();
  var temperatura_data = new Array();
  var corrente_carregador_data = new Array();

  this.mede_temperatura = (this.json_data[0].mede_temperatura == 'sim');
  this.mede_corrente_carregador = (this.json_data[0].mede_corrente_carregador == 'sim');;

  $.each(this.json_data, function(i, registro) {
    var tempo = i + 1;
    tensao_entrada_data.push(new Array(tempo, parseFloat(registro.tensao_entrada)));
    tensao_saida_data.push(new Array(tempo, parseFloat(registro.tensao_saida)));
    tensao_bateria_data.push(new Array(tempo, parseFloat(registro.tensao_bateria)));
    carga_data.push(new Array(tempo, parseFloat(registro.carga)));
    temperatura_data.push(new Array(tempo, parseFloat(registro.temperatura)));
    corrente_carregador_data.push(new Array(tempo, parseFloat(registro.corrente_carregador)));
  });

  var tensao_entrada_data_ = new Array();
  tensao_entrada_data_.push({ color: 0, data: tensao_entrada_data, label: 'Tensão de entrada' });
  var tensao_saida_data_ = new Array();
  tensao_saida_data_.push({ color: 1, data: tensao_saida_data, label: 'Tensão de saída' });
  var tensao_bateria_data_ = new Array();
  tensao_bateria_data_.push({ color: 2, data: tensao_bateria_data, label: 'Tensão da bateria' });
  var carga_data_ = new Array();
  carga_data_.push({ color: 3, data: carga_data, label: 'Carga' });
  var temperatura_data_ = new Array();
  temperatura_data_.push({ color: 4, data: temperatura_data, label: 'Temperatura' });
  var corrente_carregador_data_ = new Array();
  corrente_carregador_data_.push({ color: 5, data: corrente_carregador_data, label: 'Corrente do carregador' });

  var ultimo = this.json_data[this.json_data.length - 1];
  this.grafico_tensao_entrada = $.plot($("#grafico_tensao_entrada"), tensao_entrada_data_, this.options);
  $('#legenda_tensao_entrada').html('Tensão de entrada: ' + (ultimo.tensao_entrada + '').replace('.', ',') + ' V');
  this.grafico_tensao_saida = $.plot($("#grafico_tensao_saida"), tensao_saida_data_, this.options);
  $('#legenda_tensao_saida').html('Tensão de saída: ' + (ultimo.tensao_saida + '').replace('.', ',') + ' V');
  this.grafico_tensao_bateria = $.plot($("#grafico_tensao_bateria"), tensao_bateria_data_, this.options);
  $('#legenda_tensao_bateria').html('Tensão da bateria: ' + (ultimo.tensao_bateria + '').replace('.', ',') + ' V');
  this.grafico_carga = $.plot($("#grafico_carga"), carga_data_, this.options);
  $('#legenda_carga').html('Carga: ' + (ultimo.carga + '').replace('.', ',') + ' %');
  if (this.mede_temperatura == true) {
    this.grafico_temperatura = $.plot($("#grafico_temperatura"), temperatura_data_, this.options);
    $('#legenda_temperatura').html('Temperatura: ' + (ultimo.temperatura + '').replace('.', ',') + ' &#176;C');
  } else {
    $('#temperatura_header').remove();
    $('#temperatura_body').remove();
  }
  if (this.mede_corrente_carregador) {
    this.grafico_corrente_carregador = $.plot($("#grafico_corrente_carregador"), corrente_carregador_data_, this.options);
    $('#legenda_corrente_carregador').html('Corrente do carregador: ' + (ultimo.corrente_carregador + '').replace('.', ',') + ' mA');
  } else {
    $('#corrente_carregador_header').remove();
    $('#corrente_carregador_body').remove();
  }

  if (!this.mede_temperatura && !this.mede_corrente_carregador)
    $('#temp_cc_table').remove();

  this.desenhados = true;
}
Graficos.prototype.reget_and_replot = function() {
  if (this.atualizar && this.desenhados)
    this.get_and_plot();
}

$(function() {
  if ($('#graficos').length > 0) {
    var graficos = new Graficos();
    graficos.init();

    $(document).everyTime(3000, function(i) {
      graficos.reget_and_replot();
    });
  }
});

